<?php











namespace Composer;

use Composer\Autoload\ClassLoader;
use Composer\Semver\VersionParser;






class InstalledVersions
{
private static $installed = array (
  'root' => 
  array (
    'pretty_version' => 'dev-develop',
    'version' => 'dev-develop',
    'aliases' => 
    array (
    ),
    'reference' => 'cf31bfba2b2a87f99a1a66c317374f641cbf6e59',
    'name' => 'wprss/core',
  ),
  'versions' => 
  array (
    'container-interop/container-interop' => 
    array (
      'pretty_version' => '1.2.0',
      'version' => '1.2.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '79cbf1341c22ec75643d841642dd5d6acd83bdb8',
    ),
    'container-interop/container-interop-implementation' => 
    array (
      'provided' => 
      array (
        0 => '^1.0',
      ),
    ),
    'container-interop/service-provider' => 
    array (
      'pretty_version' => 'v0.3.0',
      'version' => '0.3.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '5cb38893b836edb00d3e1ace26c20ee1d29957cf',
    ),
    'dhii/collections-abstract' => 
    array (
      'pretty_version' => 'v0.1.0',
      'version' => '0.1.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '7c9141202af4d83b31e75efcbf481fa1cb588ad8',
    ),
    'dhii/collections-abstract-base' => 
    array (
      'pretty_version' => 'v0.1.0',
      'version' => '0.1.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '0ec0147451a72a13fb327ac6ff747c5e953c56f3',
    ),
    'dhii/collections-interface' => 
    array (
      'pretty_version' => 'v0.1.2',
      'version' => '0.1.2.0',
      'aliases' => 
      array (
      ),
      'reference' => 'a8e9a30366a30d77bc270042a67150b3f8f6d94d',
    ),
    'dhii/container-helper-base' => 
    array (
      'pretty_version' => 'v0.1-alpha8',
      'version' => '0.1.0.0-alpha8',
      'aliases' => 
      array (
      ),
      'reference' => '1b8206842e06b71abcff769aaddfc51bf8f317cd',
    ),
    'dhii/di' => 
    array (
      'pretty_version' => 'v0.1.1',
      'version' => '0.1.1.0',
      'aliases' => 
      array (
      ),
      'reference' => '52efd50f1b11fcdd2f789bae483bdb858772c306',
    ),
    'dhii/di-abstract' => 
    array (
      'pretty_version' => 'v0.1',
      'version' => '0.1.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'e87ee3782d5f4c44724e79c4b2e1a55103e5cd11',
    ),
    'dhii/di-interface' => 
    array (
      'pretty_version' => 'v0.1',
      'version' => '0.1.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '0320846a577d68b761e29acd5d4db40d88cc4f98',
    ),
    'dhii/exception' => 
    array (
      'pretty_version' => 'v0.1-alpha5',
      'version' => '0.1.0.0-alpha5',
      'aliases' => 
      array (
      ),
      'reference' => 'f7afb934c970a4e167b2c7ba24fa3df50714e0fe',
    ),
    'dhii/exception-helper-base' => 
    array (
      'replaced' => 
      array (
        0 => '0.1-alpha1|0.1-alpha2',
      ),
    ),
    'dhii/exception-interface' => 
    array (
      'pretty_version' => 'v0.2',
      'version' => '0.2.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'b69feebf7cb2879cd43977a03342e2393b73f7fb',
    ),
    'dhii/factory-interface' => 
    array (
      'pretty_version' => 'v0.1',
      'version' => '0.1.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'b8d217aec8838e64ccaa770cb03dc164bf6f0515',
    ),
    'dhii/i18n-helper-base' => 
    array (
      'pretty_version' => 'v0.1-alpha1',
      'version' => '0.1.0.0-alpha1',
      'aliases' => 
      array (
      ),
      'reference' => 'fc4c881f3e528ea918588831ebeffb92738f8dd5',
    ),
    'dhii/i18n-interface' => 
    array (
      'pretty_version' => 'v0.2',
      'version' => '0.2.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '7eaf0731ba80eea37a5deea6d894a0326e10be67',
    ),
    'dhii/iterator-helper-base' => 
    array (
      'pretty_version' => 'v0.1-alpha2',
      'version' => '0.1.0.0-alpha2',
      'aliases' => 
      array (
      ),
      'reference' => 'cf62fb9f8b658a82815f15a2d906d8d1ff5c52ce',
    ),
    'dhii/normalization-helper-base' => 
    array (
      'pretty_version' => 'v0.1-alpha4',
      'version' => '0.1.0.0-alpha4',
      'aliases' => 
      array (
      ),
      'reference' => '1b64f0ea6b3e32f9478f854f6049500795b51da7',
    ),
    'dhii/output-renderer-abstract' => 
    array (
      'pretty_version' => 'v0.1-alpha2',
      'version' => '0.1.0.0-alpha2',
      'aliases' => 
      array (
      ),
      'reference' => '0f6e5eed940025332dd1986d6c771e10f7197b1a',
    ),
    'dhii/output-renderer-base' => 
    array (
      'pretty_version' => 'v0.1-alpha1',
      'version' => '0.1.0.0-alpha1',
      'aliases' => 
      array (
      ),
      'reference' => '700483a37016e502be2ead9580bb9258ad8bf17b',
    ),
    'dhii/output-renderer-interface' => 
    array (
      'pretty_version' => 'v0.3',
      'version' => '0.3.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '407014d7fd1af0427958f2acd61aff008ee9e032',
    ),
    'dhii/stats-abstract' => 
    array (
      'pretty_version' => 'v0.1.0',
      'version' => '0.1.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '71f6702c3257c71ab3917b6d076d3c3588cc9f49',
    ),
    'dhii/stats-interface' => 
    array (
      'pretty_version' => 'v0.1.0',
      'version' => '0.1.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '36d09a8b8a3b8058214dae6eefb8ecdd98e0f0ba',
    ),
    'dhii/stringable-interface' => 
    array (
      'pretty_version' => 'v0.1',
      'version' => '0.1.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'b6653905eef2ebf377749feb80a6d18abbe913ef',
    ),
    'dhii/transformer-interface' => 
    array (
      'pretty_version' => 'v0.1-alpha1',
      'version' => '0.1.0.0-alpha1',
      'aliases' => 
      array (
      ),
      'reference' => 'e774efef46413eb34bdafc19a6bd74fbf656235d',
    ),
    'dhii/validation-abstract' => 
    array (
      'pretty_version' => 'v0.2-alpha1',
      'version' => '0.2.0.0-alpha1',
      'aliases' => 
      array (
      ),
      'reference' => 'dff998ba3476927a0fc6d10bb022425de8f1c844',
    ),
    'dhii/validation-base' => 
    array (
      'pretty_version' => 'v0.2-alpha2',
      'version' => '0.2.0.0-alpha2',
      'aliases' => 
      array (
      ),
      'reference' => '9e75c5f886a2403c6989c36c2d4ffcfae158172e',
    ),
    'dhii/validation-interface' => 
    array (
      'pretty_version' => 'v0.2',
      'version' => '0.2.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'a26026ae5cdf0a650b3511a22dbcb9329073b82c',
    ),
    'erusev/parsedown' => 
    array (
      'pretty_version' => '1.7.4',
      'version' => '1.7.4.0',
      'aliases' => 
      array (
      ),
      'reference' => 'cb17b6477dfff935958ba01325f2e8a2bfa6dab3',
    ),
    'mnapoli/php-di' => 
    array (
      'replaced' => 
      array (
        0 => '*',
      ),
    ),
    'php-di/invoker' => 
    array (
      'pretty_version' => '1.3.3',
      'version' => '1.3.3.0',
      'aliases' => 
      array (
      ),
      'reference' => '1f4ca63b9abc66109e53b255e465d0ddb5c2e3f7',
    ),
    'php-di/php-di' => 
    array (
      'pretty_version' => '5.2.2',
      'version' => '5.2.2.0',
      'aliases' => 
      array (
      ),
      'reference' => 'f574bcc841201ab04587b1c6da1234d4044f67d8',
    ),
    'php-di/phpdoc-reader' => 
    array (
      'pretty_version' => '2.1.1',
      'version' => '2.1.1.0',
      'aliases' => 
      array (
      ),
      'reference' => '15678f7451c020226807f520efb867ad26fbbfcf',
    ),
    'psr/container' => 
    array (
      'pretty_version' => '1.0.0',
      'version' => '1.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'b7ce3b176482dbbc1245ebf52b181af44c2cf55f',
    ),
    'psr/log' => 
    array (
      'pretty_version' => '1.1.2',
      'version' => '1.1.2.0',
      'aliases' => 
      array (
      ),
      'reference' => '446d54b4cb6bf489fc9d75f55843658e6f25d801',
    ),
    'rebelcode/composer-cleanup-plugin' => 
    array (
      'pretty_version' => 'v0.2',
      'version' => '0.2.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '3677eb752eb8ca042ba6f725b33f419b93857a62',
    ),
    'symfony/polyfill-ctype' => 
    array (
      'pretty_version' => 'v1.13.1',
      'version' => '1.13.1.0',
      'aliases' => 
      array (
      ),
      'reference' => 'f8f0b461be3385e56d6de3dbb5a0df24c0c275e3',
    ),
    'symfony/polyfill-mbstring' => 
    array (
      'pretty_version' => 'v1.17.1',
      'version' => '1.17.1.0',
      'aliases' => 
      array (
      ),
      'reference' => '7110338d81ce1cbc3e273136e4574663627037a7',
    ),
    'symfony/translation' => 
    array (
      'pretty_version' => 'v2.8.52',
      'version' => '2.8.52.0',
      'aliases' => 
      array (
      ),
      'reference' => 'fc58c2a19e56c29f5ba2736ec40d0119a0de2089',
    ),
    'twig/extensions' => 
    array (
      'pretty_version' => 'v1.5.4',
      'version' => '1.5.4.0',
      'aliases' => 
      array (
      ),
      'reference' => '57873c8b0c1be51caa47df2cdb824490beb16202',
    ),
    'twig/twig' => 
    array (
      'pretty_version' => 'v1.41.0',
      'version' => '1.41.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '575cd5028362da591facde1ef5d7b94553c375c9',
    ),
    'wprss/core' => 
    array (
      'pretty_version' => 'dev-develop',
      'version' => 'dev-develop',
      'aliases' => 
      array (
      ),
      'reference' => 'cf31bfba2b2a87f99a1a66c317374f641cbf6e59',
    ),
  ),
);
private static $canGetVendors;
private static $installedByVendor = array();







public static function getInstalledPackages()
{
$packages = array();
foreach (self::getInstalled() as $installed) {
$packages[] = array_keys($installed['versions']);
}


if (1 === \count($packages)) {
return $packages[0];
}

return array_keys(array_flip(\call_user_func_array('array_merge', $packages)));
}









public static function isInstalled($packageName)
{
foreach (self::getInstalled() as $installed) {
if (isset($installed['versions'][$packageName])) {
return true;
}
}

return false;
}














public static function satisfies(VersionParser $parser, $packageName, $constraint)
{
$constraint = $parser->parseConstraints($constraint);
$provided = $parser->parseConstraints(self::getVersionRanges($packageName));

return $provided->matches($constraint);
}










public static function getVersionRanges($packageName)
{
foreach (self::getInstalled() as $installed) {
if (!isset($installed['versions'][$packageName])) {
continue;
}

$ranges = array();
if (isset($installed['versions'][$packageName]['pretty_version'])) {
$ranges[] = $installed['versions'][$packageName]['pretty_version'];
}
if (array_key_exists('aliases', $installed['versions'][$packageName])) {
$ranges = array_merge($ranges, $installed['versions'][$packageName]['aliases']);
}
if (array_key_exists('replaced', $installed['versions'][$packageName])) {
$ranges = array_merge($ranges, $installed['versions'][$packageName]['replaced']);
}
if (array_key_exists('provided', $installed['versions'][$packageName])) {
$ranges = array_merge($ranges, $installed['versions'][$packageName]['provided']);
}

return implode(' || ', $ranges);
}

throw new \OutOfBoundsException('Package "' . $packageName . '" is not installed');
}





public static function getVersion($packageName)
{
foreach (self::getInstalled() as $installed) {
if (!isset($installed['versions'][$packageName])) {
continue;
}

if (!isset($installed['versions'][$packageName]['version'])) {
return null;
}

return $installed['versions'][$packageName]['version'];
}

throw new \OutOfBoundsException('Package "' . $packageName . '" is not installed');
}





public static function getPrettyVersion($packageName)
{
foreach (self::getInstalled() as $installed) {
if (!isset($installed['versions'][$packageName])) {
continue;
}

if (!isset($installed['versions'][$packageName]['pretty_version'])) {
return null;
}

return $installed['versions'][$packageName]['pretty_version'];
}

throw new \OutOfBoundsException('Package "' . $packageName . '" is not installed');
}





public static function getReference($packageName)
{
foreach (self::getInstalled() as $installed) {
if (!isset($installed['versions'][$packageName])) {
continue;
}

if (!isset($installed['versions'][$packageName]['reference'])) {
return null;
}

return $installed['versions'][$packageName]['reference'];
}

throw new \OutOfBoundsException('Package "' . $packageName . '" is not installed');
}





public static function getRootPackage()
{
$installed = self::getInstalled();

return $installed[0]['root'];
}







public static function getRawData()
{
return self::$installed;
}



















public static function reload($data)
{
self::$installed = $data;
self::$installedByVendor = array();
}




private static function getInstalled()
{
if (null === self::$canGetVendors) {
self::$canGetVendors = method_exists('Composer\Autoload\ClassLoader', 'getRegisteredLoaders');
}

$installed = array();

if (self::$canGetVendors) {
foreach (ClassLoader::getRegisteredLoaders() as $vendorDir => $loader) {
if (isset(self::$installedByVendor[$vendorDir])) {
$installed[] = self::$installedByVendor[$vendorDir];
} elseif (is_file($vendorDir.'/composer/installed.php')) {
$installed[] = self::$installedByVendor[$vendorDir] = require $vendorDir.'/composer/installed.php';
}
}
}

$installed[] = self::$installed;

return $installed;
}
}
