<?php
// *************************************************************************
// *                                                                       *
// * iBilling -  Accounting, Billing Software                              *
// * Copyright (c) Sadia Sharmin. All Rights Reserved                      *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Email: sadiasharmin3139@gmail.com                                                *
// * Website: http://www.sadiasharmin.com                                  *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.                              *
// * If you Purchased from Codecanyon, Please read the full License from   *
// * here- http://codecanyon.net/licenses/standard                         *
// *                                                                       *
// *************************************************************************
$ui->assign('_application_menu', 'invoices');
$ui->assign('_st', 'Invoices');
$ui->assign('_title', $config['CompanyName']);

if(isset($routes[1]) && ($routes[1] != '')){
    $action = $routes[1];
}
else{
    $action = 'login';
}



$ui->assign('tplheader', 'sections/client_header');
$ui->assign('tplfooter', 'sections/client_footer');


Event::trigger('client',array($action));

$jsvar = '

        _L[\'Income\'] = \''.$_L['Income'].'\';
        _L[\'Expense\'] = \''.$_L['Expense'].'\';
        _L[\'Income n Expense\'] = \''.$_L['Income n Expense'].'\';
        _L[\'Income vs Expense\'] = \''.$_L['Income vs Expense'].'\';
        _L[\'Cash Flow\'] = \''.$_L['Cash Flow'].'\';
        _L[\'Jan\'] = \''.$_L['Jan'].'\';
        _L[\'Feb\'] = \''.$_L['Feb'].'\';
        _L[\'Mar\'] = \''.$_L['Mar'].'\';
        _L[\'Apr\'] = \''.$_L['Apr'].'\';
        _L[\'May\'] = \''.$_L['May'].'\';
        _L[\'Jun\'] = \''.$_L['Jun'].'\';
        _L[\'Jul\'] = \''.$_L['Jul'].'\';
        _L[\'Aug\'] = \''.$_L['Aug'].'\';
        _L[\'Sep\'] = \''.$_L['Sep'].'\';
        _L[\'Oct\'] = \''.$_L['Oct'].'\';
        _L[\'Nov\'] = \''.$_L['Nov'].'\';
        _L[\'Dec\'] = \''.$_L['Dec'].'\';
        _L[\'Last 12 Months\'] = \''.$_L['Last 12 Months'].'\';
        _L[\'Data View\'] = \''.$_L['Data View'].'\';
        _L[\'Refresh\'] = \''.$_L['Refresh'].'\';
        _L[\'Reset\'] = \''.$_L['Reset'].'\';
        _L[\'Cancel\'] = \''.$_L['Cancel'].'\';
        _L[\'Save as Image\'] = \''.$_L['Save as Image'].'\';
        _L[\'Click to Save\'] = \''.$_L['Click to Save'].'\';
        _L[\'Average\'] = \''.$_L['Average'].'\';
        _L[\'Line\'] = \''.$_L['Line'].'\';
        _L[\'Bar\'] = \''.$_L['Bar'].'\';

        var c_month = \''.ib_lan_get_line(date('F')).'\';
        var c_year = \''.date('Y').'\';
        
        var ib_graph_primary_color = \'#233482\';
        var ib_graph_secondary_color = \'#d6150d\';




        ';



switch ($action) {


    case 'iview':

        Event::trigger('client/iview/');

        $xfooter = Asset::js(array('numeric'));

        $id  = $routes['2'];
        $d = ORM::for_table('sys_invoices')->find_one($id);
        if($d){
            $token = $routes['3'];
            $token = str_replace('token_','',$token);
            $vtoken = $d['vtoken'];
            if($token != $vtoken){
                echo 'Sorry Token does not match!';
                exit;
            }


            $items = ORM::for_table('sys_invoiceitems')->where('invoiceid',$id)->order_by_asc('id')->find_many();
            $ui->assign('items',$items);
            //find related transactions
            $trs_c = ORM::for_table('sys_transactions')->where('iid', $id)->count();

            $trs = ORM::for_table('sys_transactions')->where('iid', $id)->order_by_desc('id')->find_many();
            $ui->assign('trs', $trs);
            $ui->assign('trs_c', $trs_c);
//find the user
            $a = ORM::for_table('crm_accounts')->find_one($d['userid']);
            $ui->assign('a',$a);
            $ui->assign('d',$d);

            $i_credit = $d['credit'];
            $i_due = '0.00';
            $i_total = $d['total'];
            if($d['credit'] != '0.00'){
                $i_due = $i_total - $i_credit;
            }
            else{
                $i_due =  $d['total'];
            }




            $ui->assign('i_due', $i_due);
            $pgs = ORM::for_table('sys_pg')->where('status','Active')->order_by_asc('sorder')->find_many();
            $ui->assign('pgs',$pgs);
            $cf = ORM::for_table('crm_customfields')->where('showinvoice','Yes')->order_by_asc('id')->find_many();
            $ui->assign('cf',$cf);

            $x_html = '';

            Event::trigger('view_invoice');

            $ui->assign('xfooter', $xfooter);

            $ui->assign('xjq',' $(\'.amount\').autoNumeric(\'init\', {

    aSign: \''.$config['currency_code'].' \',
    dGroup: '.$config['thousand_separator_placement'].',
    aPad: '.$config['currency_decimal_digits'].',
    pSign: \''.$config['currency_symbol_position'].'\',
    aDec: \''.$config['dec_point'].'\',
    aSep: \''.$config['thousands_sep'].'\'

    });');


            $ui->assign('x_html',$x_html);

            $ui->display('client-iview.tpl');

        }
        else{
            r2(U . 'customers/list', 'e', $_L['Account_Not_Found']);
        }

        break;

	case 'tview':

        Event::trigger('client/tview/');

        $xfooter = Asset::js(array('numeric'));

        $id  = $routes['2'];
        $d = ORM::for_table('sys_invoices')->find_one($id);
        if($d){
            $token = $routes['3'];
            $token = str_replace('token_','',$token);
            $vtoken = $d['vtoken'];
            if($token != $vtoken){
                echo 'Sorry Token does not match!';
                exit;
            }


            $items = ORM::for_table('sys_invoiceitems')->where('invoiceid',$id)->order_by_asc('id')->find_many();
            $ui->assign('items',$items);
            //find related transactions
            $trs_c = ORM::for_table('sys_transactions')->where('iid', $id)->count();

            $trs = ORM::for_table('sys_transactions')->where('iid', $id)->order_by_desc('id')->find_many();
            $ui->assign('trs', $trs);
            $ui->assign('trs_c', $trs_c);
//find the user
            $a = ORM::for_table('crm_accounts')->find_one($d['userid']);
            $ui->assign('a',$a);
            $ui->assign('d',$d);

            $i_credit = $d['credit'];
            $i_due = '0.00';
            $i_total = $d['total'];
            if($d['credit'] != '0.00'){
                $i_due = $i_total - $i_credit;
            }
            else{
                $i_due =  $d['total'];
            }




            $ui->assign('i_due', $i_due);
            $pgs = ORM::for_table('sys_pg')->where('status','Active')->order_by_asc('sorder')->find_many();
            $ui->assign('pgs',$pgs);
            $cf = ORM::for_table('crm_customfields')->where('showinvoice','Yes')->order_by_asc('id')->find_many();
            $ui->assign('cf',$cf);

            $x_html = '';

            Event::trigger('view_invoice');

            $ui->assign('xfooter', $xfooter);

            $ui->assign('xjq',' $(\'.amount\').autoNumeric(\'init\', {

    aSign: \''.$config['currency_code'].' \',
    dGroup: '.$config['thousand_separator_placement'].',
    aPad: '.$config['currency_decimal_digits'].',
    pSign: \''.$config['currency_symbol_position'].'\',
    aDec: \''.$config['dec_point'].'\',
    aSep: \''.$config['thousands_sep'].'\'

    });');


            $ui->assign('x_html',$x_html);

            $ui->display('client-iview.tpl');

        }
        else{
            r2(U . 'customers/list', 'e', $_L['Account_Not_Found']);
        }

        break;
	
    case 'q':

        Event::trigger('client/q/');

        $id  = $routes['2'];
        $d = ORM::for_table('sys_quotes')->find_one($id);
        if($d){
            $token = $routes['3'];
            $token = str_replace('token_','',$token);
            $vtoken = $d['vtoken'];
            if($token != $vtoken){
                echo 'Sorry Token does not match!';
                exit;
            }


            $items = ORM::for_table('sys_quoteitems')->where('qid',$id)->order_by_asc('id')->find_many();
            $ui->assign('items',$items);

            $a = ORM::for_table('crm_accounts')->find_one($d['userid']);
            $ui->assign('a',$a);
            $ui->assign('d',$d);

            $cf = ORM::for_table('crm_customfields')->where('showinvoice','Yes')->order_by_asc('id')->find_many();
            $ui->assign('cf',$cf);

            $x_html = '';




            $ui->assign('x_html',$x_html);

            $ui->display('client-quote.tpl');

        }
        else{
            r2(U . 'customers/list', 'e', $_L['Account_Not_Found']);
        }

        break;




    case 'iprint':

        Event::trigger('client/iprint/');

        $id  = $routes['2'];
        $d = ORM::for_table('sys_invoices')->find_one($id);
        if($d){

            $token = $routes['3'];
            $token = str_replace('token_','',$token);
            $vtoken = $d['vtoken'];
            if($token != $vtoken){
                echo 'Sorry Token does not match!';
                exit;
            }

            //find all activity for this user
            $items = ORM::for_table('sys_invoiceitems')->where('invoiceid',$id)->order_by_asc('id')->find_many();
            $trs_c = ORM::for_table('sys_transactions')->where('iid', $id)->count();

            $trs = ORM::for_table('sys_transactions')->where('iid', $id)->order_by_desc('id')->find_many();
//find the user
            $a = ORM::for_table('crm_accounts')->find_one($d['userid']);
            $i_credit = $d['credit'];
            $i_due = '0.00';
            $i_total = $d['total'];
            if($d['credit'] != '0.00'){
                $i_due = $i_total - $i_credit;
            }
            require 'application/lib/invoices/render.php';

        }
        else{
            r2(U . 'customers/list', 'e', $_L['Account_Not_Found']);
        }

        break;

    case 'ipdf':

        Event::trigger('client/ipdf/');


        $id  = $routes['2'];
        $token = $routes['3'];

        Invoice::pdf($id,'inline',$token);



        break;



    case 'qpdf':

        Event::trigger('client/qpdf/');


        $id  = $routes['2'];

        $d = ORM::for_table('sys_quotes')->find_one($id);
        if ($d) {

            //find all activity for this user
            $items = ORM::for_table('sys_quoteitems')->where('qid', $id)->order_by_asc('id')->find_many();


            $a = ORM::for_table('crm_accounts')->find_one($d['userid']);



            $cf = ORM::for_table('crm_customfields')->where('showinvoice', 'Yes')->order_by_asc('id')->find_many();


           // define('_MPDF_PATH','application/lib/mpdf/');

           // require('application/lib/mpdf/mpdf.php');

            $pdf_c = '';
            $ib_w_font = 'dejavusanscondensed';
            if($config['pdf_font'] == 'default'){
                $pdf_c = 'c';
                $ib_w_font = 'Helvetica';
            }

         //   $mpdf=new mPDF($pdf_c,'A4','','',20,15,15,25,10,10);
          //  $mpdf->SetProtection(array('print'));

            $mpdf = new \Mpdf\Mpdf();

            $mpdf->SetTitle($config['CompanyName'].' '.$_L['Quote']);
            $mpdf->SetAuthor($config['CompanyName']);
            $mpdf->SetWatermarkText($d['status']);
            $mpdf->showWatermarkText = true;
            $mpdf->watermark_font = $ib_w_font;
            $mpdf->watermarkTextAlpha = 0.1;
            $mpdf->SetDisplayMode('fullpage');

            if($config['pdf_font'] == 'AdobeCJK'){
                $mpdf->useAdobeCJK = true;
                $mpdf->autoScriptToLang = true;
                $mpdf->autoLangToFont = true;
            }

            ob_start();

            require 'application/lib/invoices/q-x2.php';

            $html = ob_get_contents();


            ob_end_clean();

            $mpdf->WriteHTML($html);

            if (isset($routes[4]) AND ($routes[4] == 'dl')) {
                $mpdf->Output(date('Y-m-d') . _raid(4) . '.pdf', 'D'); # D
            } else {
                $mpdf->Output(date('Y-m-d') . _raid(4) . '.pdf', 'I'); # D
            }
            // $mpdf->Output();



        }
        break;


    case 'ipay':

        Event::trigger('client/ipay/');


        $id  = $routes[2];

        $token = $routes[3];



        $pg = _post('pg');

        if($pg == ''){

            $pg = route(4);

        }

        Event::trigger('client/ipay/pg',array($pg,$id,$token));

        $d = ORM::for_table('sys_invoices')->find_one($id);
        if($d){

            $token = str_replace('token_','',$token);
            $vtoken = $d['vtoken'];
            if($token != $vtoken){
                echo 'Sorry Token does not match!';
                exit;
            }

            //check pg
            $ui->assign('d',$d);


            $i_credit = $d['credit'];
            $i_due = '0.00';
            $i_total = $d['total'];


            $amount = $i_total-$i_credit;
            $invoiceid = $d['id'];
            $vtoken = $d['vtoken'];
            $ptoken = $d['ptoken'];





            //get user details

            $u = ORM::for_table('crm_accounts')->find_one($d['userid']);




            switch ($pg){

                case 'paypal':

                    $p = ORM::for_table('sys_pg')->where('processor', 'paypal')->find_one();

                    if($p){

                        // get currency

                        $currency_id = $d['currency'];

                        $currency_find = Model::factory('Models_Currency')->find_one($currency_id);

                        if($currency_find){

                            $currency = $currency_id;
                            $currency_code = $currency_find->cname;
                            $currency_rate = $currency_find->rate;


                        }
                        else{

                            $currency = 0;
                            $currency_code = $p['c1'];
                            $currency_rate = 1.0000;

                        }

                        $ppemail = $p['value'];
//

                        $c2 = $p['c2'];
                        if(($c2 != '') AND (is_numeric($c2)) AND($c2 != '1')){
                            $amount = $amount/$c2;
                            $amount = round($amount,2);
                        }

                        $url = 'https://www.paypal.com/cgi-bin/webscr';





                        $params = array(
                            array('name' => "business",
                                'value' => $ppemail
                            ),
                            array('name' => "return",
                                'value' => U . "client/ipay_submitted/$invoiceid/token_$vtoken/",
                            ),
                            array('name' => "cancel_return",
                                'value' => U . "client/ipay_cancel/$invoiceid/token_$vtoken/",
                            ),
                            array('name' => "notify_url",
                                'value' => U . "client/ipay_ipn/$invoiceid/token_$ptoken/",
                            ),
                            array('name' => "item_name",
                                'value' => "Payment For INV # $invoiceid"
                            ),
                            array('name' => "amount",
                                'value' => $amount
                            ),
                            array('name' => "cmd",
                                'value' => '_xclick'
                            ),
                            array('name' => "no_shipping",
                                'value' => '1'
                            ),
                            array('name' => "rm",
                                'value' => '2'
                            ),
                            array('name' => "currency_code",
                                'value' => $currency_code
                            )
                        );


                        Fsubmit::form($url, $params);

                    }

                    else{
                        echo 'Paypal is Not Found!';
                    }


                    break;


                case 'manualpayment':

                    Event::trigger('client/manualpayment/');

                    $p = ORM::for_table('sys_pg')->where('processor', 'manualpayment')->find_one();

                    if($p){
                        $ui->assign('i_due', $amount);
                        $ui->assign('ins',$p['value']);
                        $ui->display('client-ipay.tpl');
                    }


                    break;

                case 'stripe':
                    $p = ORM::for_table('sys_pg')->where('processor', 'stripe')->find_one();

                    if($p){
                        $a = ORM::for_table('crm_accounts')->find_one($d['userid']);
                        $it = $i_total - $i_credit;
                        $amount = $it*100;
                        $ins = ' <script
                                        src="https://checkout.stripe.com/v2/checkout.js" class="stripe-button"
                                        data-key="'.$p['value'].'"
                                        data-amount="'.$amount.'"
                                        data-name="INV #'.$d['id'].'"
                                        data-email="'.$a['email'].'"
                                        data-currency="'.$p['c1'].'"
                                        data-description="Payment for Invoice # '.$d['id'].'">
                                </script>';

                        $ui->assign('ins',$ins);

                        $ui->display('stripe.tpl');
                    }


                    break;


                case 'stripe_post':
                    $p = ORM::for_table('sys_pg')->where('processor', 'stripe')->find_one();
                    if($p){
                        $a = ORM::for_table('crm_accounts')->find_one($d['userid']);
                        $it = $i_total - $i_credit;
                        $amount = $it*100;
                        $currency_code = $p['c1'];

                        require_once('application/lib/stripe/init.php');


                        $description = "Payment For INV # $invoiceid";

                        $cardNumber = _post('cardNumber');

                        $cardExpiry = _post('cardExpiry');

                        $ce = explode('/',$cardExpiry);


                        $cardCVC = _post('cardCVC');

                        $myCard = array('number' => $cardNumber, 'exp_month' => $ce['0'], 'exp_year' => $ce['1']);


                        try {

                            \Stripe\Stripe::setApiKey($p['value']);
                            $charge = \Stripe\Charge::create(array('card' => $myCard, 'amount' => $amount, 'currency' => $currency_code,"description" => $description));


//                       $charge =  '  Stripe\Charge JSON: {
//    "id": "ch_16QJiYAN1GVPX6ZsbBl20gsJ",
//    "object": "charge",
//    "created": 1437319722,
//    "livemode": false,
//    "paid": true,
//    "status": "succeeded",
//    "amount": 193600,
//    "currency": "usd",
//    "refunded": false,
//    "source": {
//        "id": "card_16QJiYAN1GVPX6ZsDKidAMN7",
//        "object": "card",
//        "last4": "4242",
//        "brand": "Visa",
//        "funding": "credit",
//        "exp_month": 5,
//        "exp_year": 2016,
//        "fingerprint": "n0QKFME5XxL1IRG9",
//        "country": "US",
//        "name": null,
//        "address_line1": null,
//        "address_line2": null,
//        "address_city": null,
//        "address_state": null,
//        "address_zip": null,
//        "address_country": null,
//        "cvc_check": null,
//        "address_line1_check": null,
//        "address_zip_check": null,
//        "tokenization_method": null,
//        "dynamic_last4": null,
//        "metadata": [],
//        "customer": null
//    },
//    "captured": true,
//    "balance_transaction": "txn_16QJiYAN1GVPX6Zs24syLCZi",
//    "failure_message": null,
//    "failure_code": null,
//    "amount_refunded": 0,
//    "customer": null,
//    "invoice": null,
//    "description": null,
//    "dispute": null,
//    "metadata": [],
//    "statement_descriptor": null,
//    "fraud_details": [],
//    "receipt_email": null,
//    "receipt_number": null,
//    "shipping": null,
//    "destination": null,
//    "application_fee": null,
//    "refunds": {
//        "object": "list",
//        "total_count": 0,
//        "has_more": false,
//        "url": "\/v1\/charges\/ch_16QJiYAN1GVPX6ZsbBl20gsJ\/refunds",
//        "data": []
//    }
//}';



                            $charge = str_replace('Stripe\Charge JSON:','',$charge);
                           $resp = json_decode($charge,true);
                            $trid = $resp['id'];
                            $last4 = $resp['source']['last4'];
                          $captured = $resp['captured'];

                            if($captured == true){

                                $inv = ORM::for_table('sys_invoices')->find_one($id);
                                if($inv) {

                                    $inv->status = 'Paid';
                                    $inv->save();
                                    Event::trigger('invoices/markpaid/',$invoice=$inv);
                                    _msglog('s','Payment Successful');
                                    r2(U.'client/iview/'.$d['id'].'/'.'token_'.$d['vtoken']);
                                }

                            }

                            else{
                                _msglog('e','This API call cannot be made with a publishable API key. Please use a secret API key. You can find a list of your API keys at https://dashboard.stripe.com/account/apikeys.');
                                r2(U.'client/iview/'.$d['id'].'/'.'token_'.$d['vtoken']);
                            }



                        } catch(\Stripe\Error\Card $e) {
                            // Since it's a decline, \Stripe\Error\Card will be caught
                            $body = $e->getJsonBody();
                            $err  = $body['error'];

                            print('Status is:' . $e->getHttpStatus() . "\n");
                            print('Type is:' . $err['type'] . "\n");
                            print('Code is:' . $err['code'] . "\n");
                            // param is '' in this case
                            print('Param is:' . $err['param'] . "\n");
                            print('Message is:' . $err['message'] . "\n");
                        } catch (\Stripe\Error\InvalidRequest $e) {
                            // Invalid parameters were supplied to Stripe's API
                            var_dump($e);
                        } catch (\Stripe\Error\Authentication $e) {
                            // Authentication with Stripe's API failed
                            // (maybe you changed API keys recently)
                            var_dump($e);
                        } catch (\Stripe\Error\ApiConnection $e) {
                            // Network communication with Stripe failed
                        } catch (\Stripe\Error\Base $e) {
                            // Display a very generic error to the user, and maybe send
                            // yourself an email
                            var_dump($e);
                        } catch (Exception $e) {
                            // Something else happened, completely unrelated to Stripe
                            var_dump($e);
                        }

                    }

                    break;


                case 'authorize_net':

                    $p = ORM::for_table('sys_pg')->where('processor', 'authorize_net')->find_one();

                    if($p){

                        $invoiceid = $d['id'];
                        $amount = $i_total - $i_credit;
                        $url = 'https://secure.authorize.net/gateway/transact.dll';
                        $loginID = $p['value'];

                        $transactionKey = $p['c1'];

                        $description = "Invoice Payment - $invoiceid";

                        // an invoice is generated using the date and time
                        $invoice = $invoiceid;
// a sequence number is randomly generated
                        $sequence = rand(1, 1000);
// a timestamp is generated
                        $timeStamp = time();

                        $testMode = "false";
                        if (phpversion() >= '5.1.2') {
                            $fingerprint = hash_hmac("md5", $loginID . "^" . $sequence . "^" . $timeStamp . "^" . $amount . "^", $transactionKey);
                        } else {
                            $fingerprint = bin2hex(mhash(MHASH_MD5, $loginID . "^" . $sequence . "^" . $timeStamp . "^" . $amount . "^", $transactionKey));
                        }
                        $params = array(
                            array('name' => "x_login",
                                'value' => $loginID
                            ),
                            array('name' => "x_amount",
                                'value' => $amount
                            ),
                            array('name' => "x_description",
                                'value' => $description
                            ),
                            array('name' => "x_invoice_num",
                                'value' => $invoice
                            ),
                            array('name' => "x_fp_sequence",
                                'value' => $sequence
                            ),
                            array('name' => "x_fp_timestamp",
                                'value' => $timeStamp
                            ),
                            array('name' => "x_fp_hash",
                                'value' => $fingerprint
                            ),
                            array('name' => "x_test_request",
                                'value' => $testMode
                            ),
                            array('name' => "x_show_form",
                                'value' => "PAYMENT_FORM"
                            )
                        );

                        Fsubmit::form($url, $params);
                    }


                    break;


                case 'ccavenue':

                    $p = ORM::for_table('sys_pg')->where('processor', 'ccavenue')->find_one();

                    if($p){

                        require ('application/lib/misc/ccavenue.php');

                        $currency_code = $p['c2'];
                        $c3 = $p['c3'];

                        if(($c3 != '') AND (is_numeric($c3)) AND($c3 != '1')){
                            $amount = $amount/$c3;
                        }

                        $Merchant_Id = $p['value']; //Given to merchant by ccavenue


                        $WorkingKey = $p['c1']; //Given to merchant by ccavenue

                        $redirect_url = U . "client/ipay_ipn/$invoiceid/token_$ptoken/";


                        require ('application/lib/misc/ccform.php');


                        // Updated Jan 10, 2016

//                        $Checksum = getCheckSum($Merchant_Id,$amount,$invoiceid ,$redirect_url,$WorkingKey);
//
//                        $url = 'https://www.ccavenue.com/shopzone/cc_details.jsp';
//
//
//
//
//                        $params = array(
//
//                            array('name' => "merchant_id",
//                                'value' => $Merchant_Id
//                            ),
//
//                            array('name' => "Redirect_Url",
//                                'value' => $redirect_url
//                            ),
//
//                            array('name' => "amount",
//                                'value' => $amount
//                            ),
//                            array('name' => "order_id",
//                                'value' => $invoiceid
//                            ),
//                            array('name' => "Checksum",
//                                'value' => $Checksum
//                            ),
//                            array('name' => "upload",
//                                'value' => '1'
//                            ),
//                            array('name' => "ActionID",
//                                'value' => 'TXN'
//                            ),
//                            array('name' => "TxnType",
//                                'value' => 'A'
//                            ),
//                            array('name' => "num_cart_items",
//                                'value' => '1'
//                            ),
//                            array('name' => "rm",
//                                'value' => '2'
//                            ),
//                            array('name' => "payment_gross",
//                                'value' => $amount
//                            ),
//                            array('name' => "TxnType",
//                                'value' => 'A'
//                            ),
//                            array('name' => "payment_gross",
//                                'value' => $amount
//                            ),
//                            array('name' => "currency",
//                                'value' => $currency_code
//                            ),
//                            array('name' => "billing_name",
//                                'value' =>$u['account']
//                            ),
//                            array('name' => "billing_address",
//                                'value' =>$u['address']
//                            ),
//                            array('name' => "billing_city",
//                                'value' =>$u['city']
//                            ),
//                            array('name' => "billing_state",
//                                'value' =>$u['state']
//                            ),
//                            array('name' => "billing_zip",
//                                'value' =>$u['zip']
//                            ),
//                            array('name' => "billing_country",
//                                'value' =>'India'
//                            ),
//                            array('name' => "billing_tel",
//                                'value' =>$u['phone']
//                            ),
//                            array('name' => "billing_email",
//                                'value' =>$u['email']
//                            ),
//                            array('name' => "delivery_name",
//                                'value' =>$u['account']
//                            ),
//                            array('name' => "delivery_address",
//                                'value' =>$u['address']
//                            ),
//                            array('name' => "delivery_city",
//                                'value' =>$u['city']
//                            ),
//                            array('name' => "delivery_state",
//                                'value' =>$u['state']
//                            ),
//                            array('name' => "delivery_state",
//                                'value' =>$u['state']
//                            ),
//                            array('name' => "delivery_zip",
//                                'value' =>$u['zip']
//                            ),
//                            array('name' => "delivery_country",
//                                'value' =>$u['country']
//                            ),
//                            array('name' => "delivery_tel",
//                                'value' =>$u['phone']
//                            ),
//                            array('name' => "merchant_param1",
//                                'value' =>''
//                            )
//
//                        );
//
//
//                        Fsubmit::form($url, $params);

                    }



                    break;


                case 'braintree':

                    $p = ORM::for_table('sys_pg')->where('processor', 'braintree')->find_one();
                    Braintree_Configuration::environment($p['c4']);
                    Braintree_Configuration::merchantId($p['value']);
                    Braintree_Configuration::publicKey($p['c1']);
                    Braintree_Configuration::privateKey($p['c2']);

                    if($p){
                        $a = ORM::for_table('crm_accounts')->find_one($d['userid']);
                        $it = $i_total - $i_credit;
                        $amount = $it*100;
                        $clientToken = Braintree_ClientToken::generate(array());
                        $formurl = U . "client/btpay_submitted/$invoiceid/token_$vtoken/";
                        $vamount =  $config['currency_code']. number_format($d['total'],2,$config['dec_point'],$config['thousands_sep']);
                        $ins = '
                      <form id="checkout" method="post" action="'.$formurl.'">
  <div id="payment-form"></div>
  <input type="submit" value="Pay '.$config['currency_code'].' '.$vamount .'">
</form>
                      <script src="https://js.braintreegateway.com/v2/braintree.js"></script>
                      <script>
									var clientToken = "'.$clientToken.'";
									braintree.setup(clientToken, "dropin", {
  									container: "payment-form"
									});
								</script>';
                        $ui->assign('ins',$ins);
                        $ui->display('client-ipay.tpl');
                    }
                    break;



                case 'quickpay':

                    $p = ORM::for_table('sys_pg')->where('processor', 'quickpay')->find_one();

                    if($p){

                        require 'application/lib/misc/quickpay.php';

                        $qp = new Quickpay($p['value'], $p['c1']);

                        $data_fields['msgtype'] = 'authorize';
                        $data_fields['language'] = 'en';
                        $data_fields['ordernumber'] = $invoiceid;
                        $data_fields['amount'] = $amount;
                        $data_fields['currency'] = $p['c3'];
                        $data_fields['continueurl'] = U . "client/ipay_submitted/$invoiceid/token_$vtoken/";
                        $data_fields['cancelurl'] = U . "client/ipay_cancel/$invoiceid/token_$vtoken/";
                        $data_fields['callbackurl'] = U . "client/ipay_ipn/$invoiceid/token_$ptoken/";

//                   echo '
//
//<form action="https://secure.quickpay.dk/form/" method="post">
//
//'.$qp->form_fields($data_fields).'
//
//<input type="submit" value="Open Quickpay payment window" />
//
//</form>
//
//
//';

                        Fsubmit::input('https://secure.quickpay.dk/form/', $qp->form_fields($data_fields));


                    }





                    break;







                default:
                    echo 'Payment Gateway Not Found!';

            }

        }
        else{
            echo 'Sorry Invoice Not Found!';
            exit;
        }

        break;

    /*
     * CCAvenue
     *
     *
     */


    case 'ipay_cancel':

        Event::trigger('client/ipay_cancel/');

        $id  = $routes['2'];
        $token = $routes['3'];
        r2(U."client/iview/$id/$token/",'e',$_L['Payment Cancelled']);

        break;


    case 'ipay_submitted':

        Event::trigger('client/ipay_submitted/');

        $id  = $routes['2'];
        $token = $routes['3'];
        r2(U."client/iview/$id/$token/",'s',$_L['Payment Successful']);


        break;

    case 'ipay_ipn':
        Event::trigger('client/ipay_ipn/');
        $id  = $routes['2'];
        $token = $routes['3'];
        //   r2(U."client/iview/$id/$token/",'s',$_L['Payment Successful']);

        $d = ORM::for_table('sys_invoices')->find_one($id);
        if($d) {
            $token = $routes['3'];
            $token = str_replace('token_', '', $token);
            $ptoken = $d['ptoken'];
            if ($token != $ptoken) {
                echo 'Sorry Token does not match!';
                exit;
            }

            $d->status = 'Paid';
            $d->save();

            Event::trigger('invoices/markpaid/',$invoice=$d);

        }

        break;


    case 'ipay_success':

        Event::trigger('client/ipay_success/');

        $id  = $routes['2'];
        $token = $routes['3'];
        //   r2(U."client/iview/$id/$token/",'s',$_L['Payment Successful']);

        $d = ORM::for_table('sys_invoices')->find_one($id);
        if($d) {
            $token = $routes['3'];
            $token = str_replace('token_', '', $token);
            $ptoken = $d->ptoken;
            $vtoken = $d->vtoken;
            if ($token != $ptoken) {
                echo 'Sorry Token does not match!';
                exit;
            }

            $d->status = 'Paid';
            $d->save();

            Event::trigger('invoices/markpaid/',$invoice=$d);

            // send email

            $msg = Invoice::gen_email($id,'confirm');

            $subj = $msg['subject'];
            $message_o = $msg['body'];
            $email = $msg['email'];
            $name = $msg['name'];
            Notify_Email::_send($name, $email, $subj, $message_o, $d->userid, $id);

            //
            r2(U."client/iview/$id/$vtoken/",'s',$_L['Payment Successful']);

        }

        break;





    case 'btpay_submitted':

        Event::trigger('client/btpay_submitted/');

        $id  = $routes['2'];
        $d = ORM::for_table('sys_invoices')->find_one($id);
        $ui->assign('d',$d);
        $token = $routes['3'];
        $p = ORM::for_table('sys_pg')->where('processor', 'braintree')->find_one();
        if($p){
            $merchantId	= $p["value"];
            $publicKey	= $p["c1"];
            $privateKey	= $p["c2"];
            $account 	= $p["c3"];
            $environment = $p["c4"];
            $accountname = $p["name"];

            Braintree_Configuration::environment($environment);
            Braintree_Configuration::merchantId($merchantId);
            Braintree_Configuration::publicKey($publicKey);
            Braintree_Configuration::privateKey($privateKey);
            $nonce = isset( $_POST["payment_method_nonce"] )?$_POST["payment_method_nonce"]:0;
            if ($nonce) {
                // get user
                $a = ORM::for_table('crm_accounts')->find_one($d['userid']);
                // get invoice
                $id  = $routes['2'];
                $iid = $id;// invoice ID
                $i = ORM::for_table('sys_invoices')->find_one($iid);
                $d = ORM::for_table('sys_invoices')->find_one($id);
                if($d){
                    // we have an invoice, validate token...
                    $token = $routes['3'];
                    $token = str_replace('token_','',$token);
                    $vtoken = $d['vtoken'];
                    if($token != $vtoken){
                        echo 'Sorry Token does not match!';
                        exit;
                    } else {
                        // echo 'TOKEN MATCHES!!!!!!!!!!!!!!!!';
                        $i_credit = $d['credit'];
                        $i_due = '0.00';
                        $i_total = $d['total'];
                        $amount = $i_total - $i_credit;
                        $invoiceid = $d['id'];

                        $result = Braintree_Transaction::sale(array(
                            'amount' => $amount,
                            'orderId' => $id,
                            'paymentMethodNonce' => $nonce,
                            'options' => array(
                                'submitForSettlement' => True
                            )
                        ));

                        if ($result->success) {


                            $invoiceview = U . "invoices/pdf/$invoiceid/view/token_$vtoken";
                            $invoiceprint = U . "iview/print/$invoiceid/token_$vtoken";

                            // Thank you! Your payment has been successfully processed for $16.95
                            $ins = "Success!: Thank you for your payment.";
//                            $ins.= "<br />".'To PRINT your invoice click here <br> <a class="btn btn-primary" href="'.$invoiceprint.'" target="_blank">Print Invoice</a>';
//                            $date = $result->transaction->createdAt->date; //"2015-06-15 18:52:57.000000"
//                            $amount = $result->transaction->amount;
//                            $amount = Finance::amount_fix($amount);
//                            $payerid = $a["id"];
//                            $pmethod = 'Braintree';
//                            $amount = str_replace($config['currency_code'], '', $amount);
//                            $amount = str_replace(',', '', $amount);
//                            if (!is_numeric($amount)) {
//                                $msg .= 'Invalid Amount' . '<br>';
//                            }
//                            $cat = 'Consulting'; //77; // Consulting income. This should already be defined on the invoice or line item.

//                            $description = $p["name"]; //'Braintree Payment';
//                            $a = ORM::for_table('sys_accounts')->where('id', $account)->find_one(); // get braintree balance
//                            $cbal = $a['balance']; // customer balance
//                            $nbal = $cbal + $amount;
//                            $a->balance = $nbal;
//                            $a->save(); // update customer balance
//                            $d = ORM::for_table('sys_transactions')->create(); // BOF add a transaction
//                            $d->account = $accountname;
//                            $d->type = 'Income';
//                            $d->payerid = $payerid;
//
//                            $d->amount = $amount;
//                            $d->category = $cat;
//                            $d->method = $pmethod;
//                            $d->description = 'Invoice '.$id .' Payment'; //$description;
//                            $d->date = date('Y-m-d');//"2015-06-15 18:52:57.000000"
//                            $d->dr = '0.00';
//                            $d->cr = $amount;
//                            $d->bal = $nbal;
//                            $d->iid = $iid;
//                            $d->save(); // BOF add a transaction
//                            $tid = $d->id();
//                            // log it...
//                            _log('New Deposit: ' . $description . ' [TrID: ' . $tid . ' | Amount: ' . $amount . ']', 'Admin',$payerid);
//                            _msglog('s', 'Transaction Added Successfully');

                            if ($i) {
                                $pc = $i['credit'];
                                $it = $i['total'];
                                $dp = $it - $pc;
                                if (($dp == $amount) OR (($dp < $amount))) {
                                    $i->status = 'Paid';
                                    $i->datepaid = date('Y-m-d H:i:s');
                                    Event::trigger('invoices/markpaid/',$invoice=$i);
                                } else {
                                    $i->status = 'Partially Paid';
                                }
                                $i->credit = $pc + $amount;
                                $i->paymentmethod = $accountname;
                                $i->save();

                            } //if ($i) {
                        } else if ($result->transaction) {
                            $ins = "Error processing transaction:";
                            $ins .= ("\n  code: " . $result->transaction->processorResponseCode);
                            $ins .= ("\n  text: " . $result->transaction->processorResponseText);
                        } else {
                            $ins = ("Validation errors: \n");
                            $ins .= ($result->errors->deepAll());
                        }
//                        $ui->assign('ins',$ins);
//                        $ui->display('client-ipay.tpl');
                        r2(U.'client/iview/'.$i->id.'/'.$i->vtoken.'/','s',$ins);
                    }
                }
            }
            /* eof bernie changes */
        } else echo 'Payment Gateway Not Found!';


        break;

    case 'ccsubmit':


        $p = ORM::for_table('sys_pg')->where('processor', 'ccavenue')->find_one();

        if($p) {

            require('application/lib/misc/ccavenue.php');

            $currency_code = $p['c2'];
            $c3 = $p['c3'];

            if (($c3 != '') AND (is_numeric($c3)) AND ($c3 != '1')) {
                $amount = $amount / $c3;
            }

            $Merchant_Id = $p['value']; //Given to merchant by ccavenue


            $WorkingKey = $p['c1']; //Given to merchant by ccavenue

            $redirect_url = U . "client/ipay_ipn/$invoiceid/token_$ptoken/";


            require('application/lib/misc/ccsubmit.php');

        }


        break;



    case 'login':

        Event::trigger('client/login/');

        Contacts::isLogged();


        $ui->display('client_login.tpl');


        break;


    case 'register':
        $extra_fields = array();
        $ui->assign('extra_fields',$extra_fields);
        Event::trigger('client/register/');

        Contacts::isLogged();

        $ui->assign('xfooter',Asset::js(array('contacts/register')));


        $ui->display('client_register.tpl');


        break;

    case 'forgot_pw':

        Event::trigger('client/forgot_pw/');

        $ui->display('client_forgot_pw.tpl');


        break;

    case 'forgot_pw_post':

        Event::trigger('client/forgot_pw_post/');

        $username = _post('username');

        $d = ORM::for_table('crm_accounts')->where('email',$username)->find_one();

        if($d){

            //

            $fullname = $d->account;

            $password = Ib_Str::random_string(8);

            $password_hash = Password::_crypt($password);

            $d->password = $password_hash;

            $d->save();

            // Send email notification

            $mail = Notify_Email::_init();
            $mail->AddAddress($username, $fullname);
            $mail->Subject = 'Password Reset for '.$config['CompanyName'];
            $mail->MsgHTML('Your Password has been reset to: '. $password.' Go to this link to login with new password- '.U.'client/login/');
            $mail->Send();

            r2(U.'client/login/','s','New Password has been sent to your email.');



        }

        else{

            r2(U.'client/forgot_pw/','e','No User found with this Email');

        }



        break;

    case 'auth':

        Event::trigger('client/auth/');

        $email = _post('username');
        $password = _post('password');

        $remember_me = _post('remember_me');

        $auth = Contacts::login($email,$password);

        if($auth){

            // store authentication key in the cookies

            if($remember_me == 'yes'){
                setcookie('ib_ct', $auth, time() + (86400 * 30), "/"); // 86400 = 1 day
            }
            else{

                $_SESSION['ib_ct'] = $auth;

            }



            r2(U.'client/dashboard/');



        }
        else{
            r2(U.'client/login/','e',$_L['Invalid Username or Password']);
        }




        break;


    case 'auto_login':
        Event::trigger('client/auto_login/');



        break;


    case 'register_post':

       // sleep(3);

        if(!isset($_SESSION['recaptcha_verified'])){
            $_SESSION['recaptcha_verified'] = false;
        }

        if($config['recaptcha'] == 1){


            if(!$_SESSION['recaptcha_verified']){

                if(Ib_Recaptcha::isValid($config['recaptcha_secretkey']) == false){

                    ib_die($_L['Recaptcha Verification Failed']);

                }
                else{

                    $_SESSION['recaptcha_verified'] = true;

                }

            }



        }

        $msg = '';

        $data = array();

        Event::trigger('client/register_post/');



        $data['account'] = _post('fullname');
        $data['email'] = _post('email');
        $data['password'] = _post('password');
        $data['password2'] = _post('password2');

        $o_password = $data['password'];

        if($data['account'] == ''){
            $msg .= 'Fullname is required <br>';
        }

        if(Validator::Email($data['email']) == false){
            $msg .= $_L['Invalid Email'].' <br>';
        }
        $f = ORM::for_table('crm_accounts')->where('email',$data['email'])->find_one();

        if($f){
            $msg .= $_L['Email already exist'].' <br>';
        }



        if($data['password'] != ''){

            if(!Validator::Length($data['password'],15,5)){
                $msg .= 'Password should be between 6 to 15 characters'. '<br>';

            }

            if($data['password'] != $data['password2']){
                $msg .= 'Passwords does not match'. '<br>';
            }


            $data['password'] = Password::_crypt($data['password']);


        }
        else{

            $msg .= 'Password is required <br>';

        }

        // API call for extra fields



        //

        // optional params

        $data['phone'] = _post('phone');
        $data['address'] = _post('address');
        $data['city'] = _post('city');
        $data['zip'] = _post('zip');
        $data['state'] = _post('');
        $data['country'] = _post('country');
        $data['company'] = _post('company');
        $data['created_at'] = date('Y-m-d H:i:s');
        $data['updated_at'] = date('Y-m-d H:i:s');
        $data['email_verified'] = 'No';
        $ip = get_client_ip();
        $data['signed_up_ip'] = $ip;
        $isp = gethostbyaddr($ip);
        if(!$isp){

            $isp = '';

        }

        $data['isp'] = $isp;
        $data['balance'] = '0.00';
        $data['status'] = 'Active';
        $data['notes'] = '';
        $data['token'] = '';
        $data['img'] = '';
        $data['web'] = '';
        $data['facebook'] = '';
        $data['google'] = '';
        $data['linkedin'] = '';
        $data['twitter'] = '';
        $data['skype'] = '';
//        $data[''] = '';


//        $ = _post('');



        Event::trigger('client_register_post_data_posted');


        if($msg == ''){

            // create client




            // try to guess location



            //

            $d = ORM::for_table('crm_accounts')->create();

            $d->account = $data['account'];
            $d->email = $data['email'];
            $d->phone = $data['phone'];
            $d->address = $data['address'];
            $d->city = $data['city'];
            $d->zip = $data['zip'];
            $d->state = $data['state'];
            $d->country = $data['country'];
            $d->tags = '';

            //others
            $d->fname = '';
            $d->lname = '';
            $d->company = $data['company'];
            $d->jobtitle = '';
            $d->cid = '0';
            $d->o = '0';
            $d->balance = $data['balance'];
            $d->status = $data['status'];
            $d->notes = $data['notes'];
            $d->password = $data['password'];
            $d->token = '';
            $d->ts = '';
            $d->img = $data['img'];
            $d->web = $data['web'];
            $d->facebook = $data['facebook'];
            $d->google = $data['google'];
            $d->linkedin = $data['linkedin'];

            // v 4.2

            $d->gname = '';
            $d->gid = 0;

            $d->signed_up_ip = $ip;
            $d->isp = $data['isp'];

            //
            $d->save();
            $cid = $d->id();
            _log($_L['New Contact Added'].' '.$data['account'].' [CID: '.$cid.']','Portal Registration');


            $send_email = Ib_Email::send_client_welcome_email($data);

            $auth = Contacts::login($data['email'],$o_password);

            if($auth){

                // store authentication key in the cookies

                setcookie('ib_ct', $auth, time() + (86400 * 30), "/"); // 86400 = 1 day



            }

            echo $cid;

            Event::trigger('client/client_registered',$data);




        }

        else{

            echo $msg;

        }






        break;


    case 'dashboard':

        $dashboard_summary_extras = '';
        $dashboard_extra_row_1 = '';
        $c = Contacts::details();

        Event::trigger('client/dashboard/');

        $ui->assign('_application_menu', 'dashboard');
        $ui->assign('_st', $_L['Dashboard']);
        $ui->assign('_title', $config['CompanyName'].' - '.$_L['Dashboard']);

        $cf = ORM::for_table('crm_customfields')->where('ctype','crm')->order_by_asc('id')->find_many();
        $ui->assign('cf',$cf);

        $ui->assign('user',$c);

        $cid = $c->id;

        $d = ORM::for_table('sys_transactions')
            ->where_any_is(array(
                array('payerid' => $cid),
                array('payeeid' => $cid)))->limit(5)
            ->find_many();
  
        $ui->assign('t',$d);

        $d = ORM::for_table('sys_invoices')->where('userid',$c->id)->limit(5)->find_array();

        $ui->assign('d',$d);

        $d = ORM::for_table('sys_quotes')->where('userid',$c->id)->limit(5)->find_array();

        $ui->assign('q',$d);

        $ui->assign('xjq',' $(\'.amount\').autoNumeric(\'init\', {

    
    dGroup: '.$config['thousand_separator_placement'].',
    aPad: '.$config['currency_decimal_digits'].',
    pSign: \''.$config['currency_symbol_position'].'\',
    aDec: \''.$config['dec_point'].'\',
    aSep: \''.$config['thousands_sep'].'\'

    });');

        $ui->assign('dashboard_summary_extras',$dashboard_summary_extras);
        $ui->assign('dashboard_extra_row_1',$dashboard_extra_row_1);
        $ui->display('client_dashboard.tpl');

        break;

    case 'invoices':
        Event::trigger('client/invoices/');
        $ui->assign('_application_menu', 'invoices');
        $ui->assign('_st', $_L['Invoices']);
        $ui->assign('_title', $config['CompanyName'].' - '.$_L['Invoices']);

        $c = Contacts::details();

        $ui->assign('user',$c);

        $d = ORM::for_table('sys_invoices')->where('userid',$c->id)->find_array();

        $ui->assign('d',$d);

        $ui->assign('total_invoice',count($d));

        //  aSign: \''.$config['currency_code'].' \',

        $ui->assign('xjq',' $(\'.amount\').autoNumeric(\'init\', {

   
    dGroup: '.$config['thousand_separator_placement'].',
    aPad: '.$config['currency_decimal_digits'].',
    pSign: \''.$config['currency_symbol_position'].'\',
    aDec: \''.$config['dec_point'].'\',
    aSep: \''.$config['thousands_sep'].'\'

    });');


        $ui->display('client_invoices.tpl');


        break;
		
	 case 'evaluations':
        Event::trigger('client/evaluations/');
        $ui->assign('_application_menu', 'invoices');
        $ui->assign('_st', 'Assessments');
        $ui->assign('_title', $config['CompanyName'].' - '.$_L['Invoices']);

        $c = Contacts::details();

        $ui->assign('user',$c);

        $d = ORM::for_table('sys_topics')->find_array();
        $ui->assign('d',$d);

        $ui->assign('total_topics',count($d));
		
		//$evals = ORM::for_table('sys_evalitems')->find_array();
       // $ui->assign('evals',$evals);
		
        //  aSign: \''.$config['currency_code'].' \',

        $ui->assign('xjq',' $(\'.amount\').autoNumeric(\'init\', {

   
    dGroup: '.$config['thousand_separator_placement'].',
    aPad: '.$config['currency_decimal_digits'].',
    pSign: \''.$config['currency_symbol_position'].'\',
    aDec: \''.$config['dec_point'].'\',
    aSep: \''.$config['thousands_sep'].'\'

    });');


        $ui->display('client_evaluations.tpl');


        break;
		
case 'results':
        Event::trigger('client/results/');
        $ui->assign('_application_menu', 'invoices');
        $ui->assign('_st','Assessments');
        $ui->assign('_title', $config['CompanyName'].' - '.$_L['Invoices']);

        $c = Contacts::details();

        $ui->assign('user',$c);

        $d = ORM::for_table('sys_results')->where('userid',$c['id'])->find_array();
        $ui->assign('d',$d);

        $ui->assign('total_topics',count($d));
		
		//$evals = ORM::for_table('sys_evalitems')->find_array();
       // $ui->assign('evals',$evals);
		
        //  aSign: \''.$config['currency_code'].' \',

        $ui->assign('xjq',' $(\'.amount\').autoNumeric(\'init\', {

   
    dGroup: '.$config['thousand_separator_placement'].',
    aPad: '.$config['currency_decimal_digits'].',
    pSign: \''.$config['currency_symbol_position'].'\',
    aDec: \''.$config['dec_point'].'\',
    aSep: \''.$config['thousands_sep'].'\'

    });');
        $ui->display('client_results.tpl');


        break;		
		

    case 'quotes':
        Event::trigger('client/quotes/');
        $ui->assign('_application_menu', 'quotes');
        $ui->assign('_st', $_L['Quotes']);
        $ui->assign('_title', $config['CompanyName'].' - '.$_L['Quotes']);

        $c = Contacts::details();

        $ui->assign('user',$c);

        $d = ORM::for_table('sys_quotes')->where('userid',$c->id)->find_array();

        $ui->assign('d',$d);

        $ui->assign('total_quotes',count($d));

        $ui->assign('xjq',' $(\'.amount\').autoNumeric(\'init\', {

    aSign: \''.$config['currency_code'].' \',
    dGroup: '.$config['thousand_separator_placement'].',
    aPad: '.$config['currency_decimal_digits'].',
    pSign: \''.$config['currency_symbol_position'].'\',
    aDec: \''.$config['dec_point'].'\',
    aSep: \''.$config['thousands_sep'].'\'

    });');

        $ui->display('client_quotes.tpl');


        break;

    case 'transactions':
        Event::trigger('client/transactions/');
        $ui->assign('_application_menu', 'transactions');
        $ui->assign('_st', $_L['Transactions']);
        $ui->assign('_title', $config['CompanyName'].' - '.$_L['Transactions']);

        $c = Contacts::details();

        $cid = $c->id;

        $ui->assign('user',$c);

        $d = ORM::for_table('sys_transactions')
            ->where_any_is(array(
                array('payerid' => $cid),
                array('payeeid' => $cid)))
            ->find_many();
        $ui->assign('d',$d);

        $ti = ORM::for_table('sys_transactions')
            ->where('payerid',$cid)
            ->sum('cr');
        if($ti == ''){
            $ti = '0';
        }
        $ui->assign('ti',$ti);
        $te = ORM::for_table('sys_transactions')
            ->where('payeeid',$cid)
            ->sum('dr');
        if($te == ''){
            $te = '0';
        }

        $ui->assign('total_quotes',count($d));

        $ui->assign('xjq',' $(\'.amount\').autoNumeric(\'init\', {

    aSign: \''.$config['currency_code'].' \',
    dGroup: '.$config['thousand_separator_placement'].',
    aPad: '.$config['currency_decimal_digits'].',
    pSign: \''.$config['currency_symbol_position'].'\',
    aDec: \''.$config['dec_point'].'\',
    aSep: \''.$config['thousands_sep'].'\'

    });');

        $ui->display('client_transactions.tpl');



        break;


    case 'profile':
        Event::trigger('client/profile/');
        $ui->assign('_application_menu', 'profile');
        $ui->assign('_st', $_L['Profile']);
        $ui->assign('_title', $config['CompanyName'].' - '.$_L['Profile']);
        $c = Contacts::details();
        $ui->assign('user',$c);
        $ui->assign('d',$c);
        $ui->assign('countries',Countries::all($c->country));
        $ui->assign('xfooter',Asset::js(array('contacts/client_profile_edit')));
        $cf = ORM::for_table('crm_customfields')->where('ctype','crm')->order_by_asc('id')->find_many();
        $ui->assign('cf',$cf);
        $ui->display('client_profile.tpl');



        break;


    case 'profile_edit_post':
        Event::trigger('client/profile_edit_post/');
        $c = Contacts::details();
        $id = $c->id;
        $d = ORM::for_table('crm_accounts')->find_one($id);
        if($d){

            $account = _post('account');
            $company = _post('company');

            $email = _post('edit_email');




            $phone = _post('phone');
            $address = _post('address');
            $city = _post('city');
            $state = _post('state');
            $zip = _post('zip');
            $country = _post('country');
            $msg = '';

            if($account == ''){
                $msg .= $_L['Account Name is required']. ' <br>';
            }



            if($email != ($d['email'])){
                $f = ORM::for_table('crm_accounts')->where('email',$email)->find_one();

                if($f){
                    $msg .= $_L['Email already exist'].' <br>';
                }
            }
            if(Validator::Email($email) == false){
                $msg .= $_L['Invalid Email'].' <br>';
            }




            $password = _post('password');




            if($msg == ''){


                $d = ORM::for_table('crm_accounts')->find_one($id);
                $d->account = $account;
                $d->company = $company;


                $d->email = $email;

                $d->phone = $phone;
                $d->address = $address;
                $d->city = $city;
                $d->zip = $zip;
                $d->state = $state;
                $d->country = $country;



                if($password != ''){

                    $d->password = Password::_crypt($password);

                }

                $d->save();





                _msglog('s',$_L['account_updated_successfully']);

                echo $id;
            }
            else{
                echo $msg;
            }

        }
        else{
            r2(U.$myCtrl.'/list', 'e', $_L['Account_Not_Found']);
        }


        break;






    case 'logout':
        Event::trigger('client/logout/');
        $c = Contacts::details();

        session_destroy();

        Contacts::logout_using_token($c->token);


        setcookie('ib_ct', 'expired', 1, "/");

        r2(U.'client/login/','s','You have successfully logged out.');



        break;

    case 'where':

        r2(U.'client/login/');

        break;


    case 'q_accept':

        $id = route(2);

        $d = ORM::for_table('sys_quotes')->find_one($id);
        if($d) {
            $token = $routes['3'];
            $token = str_replace('token_', '', $token);
            $vtoken = $d['vtoken'];
            if ($token != $vtoken) {
                echo 'Sorry Token does not match!';
                exit;
            }

            $d->stage = 'Accepted';
            $d->save();

            r2(U.'client/q/'.$id.'/token_'.$vtoken.'/');


        }





        break;

    case 'q_decline':

        $id = route(2);

        $d = ORM::for_table('sys_quotes')->find_one($id);
        if($d) {
            $token = $routes['3'];
            $token = str_replace('token_', '', $token);
            $vtoken = $d['vtoken'];
            if ($token != $vtoken) {
                echo 'Sorry Token does not match!';
                exit;
            }

            $d->stage = 'Lost';
            $d->save();

            r2(U.'client/q/'.$id.'/token_'.$vtoken.'/');

        }


        break;


    case 'dl':


        require 'application/helpers/mime.php';

        $req = route(2);

        $req_e = explode('_',$req);

        $id = $req_e[0];

        $token = $req_e[1];




        $doc = ORM::for_table('sys_documents')->find_one($id);

        if($doc){

            $db_token = $doc->file_dl_token;

            if($db_token != $token){
                i_close('Token does not match.');
            }

            $file_path = $doc->file_path;

            $file = 'application/storage/docs/'.$file_path;

            $ext = pathinfo($file_path, PATHINFO_EXTENSION);

            $file_name = $doc->title;

            $file_name = str_replace(' ','_',$file_name);

            $file_name = strtolower($file_name);

            $dl_file_name = $file_name.'.'.$ext;

            $c_type = mime_content_type($file);




            if (file_exists($file)) {
                $basename = basename($file);


                // $mime = ($mime = getimagesize($file)) ? $mime['mime'] : $mime;
                $mime = mime_content_type($file);
                $size = filesize($file);
                $fp   = fopen($file, "rb");
                if (!($mime && $size && $fp)) {
                    // Error.
                    return;
                }

                header("Content-type: " . $mime);
                header("Content-Length: " . $size);
              //  header("Content-Disposition: attachment; filename=" . $basename);
                header("Content-Disposition: attachment; filename=" . $dl_file_name);
                header('Content-Transfer-Encoding: binary');
                header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
                fpassthru($fp);
            }

        }
        else{
            i_close('Not Found');
        }


        break;


    case 'downloads':

        $ui->assign('_application_menu', 'downloads');
        $ui->assign('_st', $_L['Downloads']);
        $ui->assign('_title', $config['CompanyName'].' - '.$_L['Downloads']);

        $c = Contacts::details();

        $ui->assign('user',$c);

        $file_ids = ORM::for_table('ib_doc_rel')->where('rtype','contact')->where('rid',$c->id)->find_array();


        $ids = array();

        foreach ($file_ids as $f){

            $ids[] = $f['did'];

        }

        if (!empty($ids)) {

            $d = ORM::for_table('sys_documents')->where_in('id', $ids)->find_many();

        }

        else{
            $d = array();
        }





        $ui->assign('d',$d);



        $ui->display('client_downloads.tpl');


        break;

    case 'orders':

        $ui->assign('_application_menu', 'orders');
        $ui->assign('_st', $_L['Orders']);
        $ui->assign('_title', $config['CompanyName'].' - '.$_L['Orders']);

        $c = Contacts::details();

        $ui->assign('user',$c);

        $d = ORM::for_table('sys_orders')->where('cid',$c->id)->find_array();
        $ui->assign('d',$d);

        $xjq = '

    $(\'.amount\').autoNumeric(\'init\', {

    aSign: \''.$config['currency_code'].' \',
    dGroup: '.$config['thousand_separator_placement'].',
    aPad: '.$config['currency_decimal_digits'].',
    pSign: \''.$config['currency_symbol_position'].'\',
    aDec: \''.$config['dec_point'].'\',
    aSep: \''.$config['thousands_sep'].'\'

    });

 ';

        $ui->assign('xjq', $xjq);

        $ui->display('client_orders.tpl');


        break;

    case 'order_view':

        $ui->assign('_application_menu', 'orders');
        $ui->assign('_st', $_L['Orders']);
        $ui->assign('_title', $config['CompanyName'].' - '.$_L['Orders']);

        $c = Contacts::details();

        $ui->assign('user',$c);

        $xjq = '

    $(\'.amount\').autoNumeric(\'init\', {

    aSign: \''.$config['currency_code'].' \',
    dGroup: '.$config['thousand_separator_placement'].',
    aPad: '.$config['currency_decimal_digits'].',
    pSign: \''.$config['currency_symbol_position'].'\',
    aDec: \''.$config['dec_point'].'\',
    aSep: \''.$config['thousands_sep'].'\'

    });

 ';

        $ui->assign('xjq', $xjq);

        $oid = route(2);
        $ordernum = route(3);

        $order = ORM::for_table('sys_orders')->find_one($oid);

        if($order){

            $db_ordernum = $order->ordernum;

            if($ordernum != $db_ordernum){
                i_close('Order number does not match.');
            }

            $ui->assign('order',$order);

            $ui->display('client_order_view.tpl');



        }


        break;

    case 'autologin':

        $token = route(2);

        $token_length = strlen($token);

        if($token_length < 20){
            i_close('Invalid Token.');
        }

        $d = ORM::for_table('crm_accounts')->where('autologin',$token)->find_one();

        if($d){

            $auth_key = Ib_Str::random_string(20).md5(time());

            $d->token = $auth_key;

            $d->save();

            setcookie('ib_ct', $auth_key, time() + (86400 * 30), "/"); // 86400 = 1 day

            r2(U.'client/dashboard/');

        }

        else{
            i_close('Token Expired.');
        }




        break;
	
	



		
	case 'tadd': //ADD TESTS

        Event::trigger('client/add/');

        $extra_fields = '';
        $extra_jq = '';
    //    Event::trigger('add_test');
        $c = Contacts::details();

        $ui->assign('user',$c);
		
		$ui->assign('extra_fields', $extra_fields);
        $topicid = $routes['2'];
		$ui->assign('topicid',$topicid);
		
        $ui->assign('_st','Take Assessment');
        $c = ORM::for_table('crm_accounts')->select('id')->select('account')->select('company')->select('email')->order_by_desc('id')->find_many();
        $ui->assign('c', $c);
		
		$evals = ORM::for_table('sys_evaluations')->select('id')->select('topicid')->select('account')->where('topicid',$topicid)->find_many();
        $ui->assign('evals', $evals);

        $ui->assign('idate', date('Y-m-d'));
	
        $js_file = 'test_add';
        $tpl_file = 'add_test_v2.tpl';
       
        $css_arr = array('s2/css/select2.min','modal','dp/dist/datepicker.min','redactor/redactor');
        $js_arr = array('redactor/redactor.min','s2/js/select2.min','s2/js/i18n/'.lan(),'dp/dist/datepicker.min','dp/i18n/'.$config['language'],'numeric');

        $ui->assign('xheader', Asset::css($css_arr));
        $ui->assign('xfooter', Asset::js($js_arr));
		// $ui->assign('xfooter',Asset::js(array('contacts/client_profile_edit')));
        $ui->display($tpl_file);
        
		break;
		
    case 'tadd-post':

        Event::trigger('client/tadd-post/');
        $user = Contacts::details();
  		
		$msg = '';

        if (isset($_POST['eaddress'])) { $eaddress = $_POST['eaddress']; } else { $msg .= $_L['at_least_one_item_required'].' <br> '; }
		if (isset($_POST['gender'])) { $gender = $_POST['gender']; } else { $msg .= $_L['at_least_one_item_required'].' <br> '; }
		if (isset($_POST['lvledu'])) { $lvledu = $_POST['lvledu']; } else { $msg .= $_L['at_least_one_item_required'].' <br> '; }
		if (isset($_POST['training'])) { $training = $_POST['training']; } else { $msg .= $_L['at_least_one_item_required'].' <br> '; }
		if (isset($_POST['noy'])) { $noy = $_POST['noy']; } else { $msg .= $_L['at_least_one_item_required'].' <br> '; }
		if (isset($_POST['yexp'])) { $yexp = $_POST['yexp']; } else { $msg .= $_L['at_least_one_item_required'].' <br> '; }
		
        $evalitemid = $_POST['evalitemid'];
		$evalid = $_POST['evalid'];
		$qty = array();
		$qty = $_POST['qty'];
        $i = '0';
        $a = array();

		if ($msg == '') {
			
        $datetime = date("Y-m-d H:i:s");
			
        $d = ORM::for_table('crm_testers')->create();
		$d->noy = $noy;
		$d->userid = $user['id'];
		$d->gender = $gender;
		$d->lvledu = $lvledu;
		$d->training = $training;
		$d->created_at = $datetime;
		$d->yexp = $yexp;
		$d->save();
            
		$testerid = $d->id();
		
		$sr = ORM::for_table('sys_results')->create();
		$sr->userid = $user['id'];
		$sr->topicid = '1';
		$sr->testerid = $testerid;
		$sr->date = $datetime;
		$sr->status= 'Active';
		$sr->save();
		
		$resultid = $d->id();
			
		$i = '0';
            
			foreach ($qty as $results) {
             	$sqty = $qty[$i];
				$sevalitemid = $evalitemid[$i];
				$sevalid = $evalid[$i];
					
				$de = ORM::for_table('sys_tests')->create();
				$de->userid = $user['id'];
				$de->evalid = $sevalid;
				$de->testerid = $testerid;
				$de->evalitemid = $sevalitemid;
				$de->date = date('Y-m-d');
				$de->level = $sqty;
				$de->resultid = $resultid;
				$de->save();
				$i++;
            }
			$testid = $de->id();
          //  Event::trigger('add_invoice_posted');

            //echo $testid;
			      r2(U.'client/dashboard/');

        } else {
            echo $msg;
        }

        break;
case 'view-actionplan': 

        Event::trigger('client/view-actionplan/');

        $extra_fields = '';
        $extra_jq = '';
    //    Event::trigger('add_test');
        $c = Contacts::details();

        $ui->assign('user',$c);
		
		$ui->assign('extra_fields', $extra_fields);
        $resultid = $routes['2'];
		$ui->assign('resultid',$resultid);
		
        $ui->assign('_st','View Action Plan');
        $c = ORM::for_table('crm_accounts')->select('id')->select('account')->select('company')->select('email')->order_by_desc('id')->find_many();
        $ui->assign('c', $c);
		
		$actpl = ORM::for_table('sys_actionplan')->where('id',$resultid)->find_many();
       $ui->assign('actpl', $actpl);

      //  $ui->assign('idate', date('Y-m-d'));
	
        $js_file = 'test_add';
        $tpl_file = 'view_actionplan.tpl';
       
        $css_arr = array('s2/css/select2.min','modal','dp/dist/datepicker.min','redactor/redactor');
        $js_arr = array('redactor/redactor.min','s2/js/select2.min','s2/js/i18n/'.lan(),'dp/dist/datepicker.min','dp/i18n/'.$config['language'],'numeric');

        $ui->assign('xheader', Asset::css($css_arr));
        $ui->assign('xfooter', Asset::js($js_arr));
		// $ui->assign('xfooter',Asset::js(array('contacts/client_profile_edit')));
        $ui->display($tpl_file);
        
		break;

 case 'add-actionplan': //ADD TESTS

        Event::trigger('client/add-actionplan/');

        $extra_fields = '';
        $extra_jq = '';
    //    Event::trigger('add_test');
        $c = Contacts::details();

        $ui->assign('user',$c);
		
		$ui->assign('extra_fields', $extra_fields);
        $resultid = $routes['2'];
		$ui->assign('resultid',$resultid);
		
        $ui->assign('_st','Add Action Plan');
        $c = ORM::for_table('crm_accounts')->select('id')->select('account')->select('company')->select('email')->order_by_desc('id')->find_many();
        $ui->assign('c', $c);
		
		//$evals = ORM::for_table('sys_evaluations')->select('id')->select('topicid')->select('account')->where('topicid',$topicid)->find_many();
       // $ui->assign('evals', $evals);

      //  $ui->assign('idate', date('Y-m-d'));
	
        $js_file = 'test_add';
        $tpl_file = 'add_actionplan.tpl';
       
        $css_arr = array('s2/css/select2.min','modal','dp/dist/datepicker.min','redactor/redactor');
        $js_arr = array('redactor/redactor.min','s2/js/select2.min','s2/js/i18n/'.lan(),'dp/dist/datepicker.min','dp/i18n/'.$config['language'],'numeric');

        $ui->assign('xheader', Asset::css($css_arr));
        $ui->assign('xfooter', Asset::js($js_arr));
		// $ui->assign('xfooter',Asset::js(array('contacts/client_profile_edit')));
        $ui->display($tpl_file);
        
		break;
		
    case 'add-actionplan-post':

        Event::trigger('client/add-actionplan-post/');
        $user = Contacts::details();
  		$resultid = '';
		
		$msg = '';
		$resultid = $_POST['resultid'];

		$weakness1 = $_POST['weakness1'];
		$weakness2 = $_POST['weakness2'];
		$weakness3 = $_POST['weakness3'];
		$weakness4 = $_POST['weakness4'];
		$weakness5 = $_POST['weakness5'];
		$weakness6 = $_POST['weakness6'];
		$weakness7 = $_POST['weakness7'];
		
        $skills1 = $_POST['skills1'];
		$skills2 = $_POST['skills2'];
		$skills3 = $_POST['skills3'];
		$skills4 = $_POST['skills4'];
		$skills5 = $_POST['skills5'];
		$skills6 = $_POST['skills6'];
		$skills7 = $_POST['skills7'];		
		
		$capacity1 = $_POST['capacity1'];
		$capacity2 = $_POST['capacity2'];
		$capacity3 = $_POST['capacity3'];
		$capacity4 = $_POST['capacity4'];
		$capacity5 = $_POST['capacity5'];
		$capacity6 = $_POST['capacity6'];
		$capacity7 = $_POST['capacity7'];
		
		$suggested1 = $_POST['suggested1'];
		$suggested2 = $_POST['suggested2'];
		$suggested3 = $_POST['suggested3'];
		$suggested4 = $_POST['suggested4'];
		$suggested5 = $_POST['suggested5'];
		$suggested6 = $_POST['suggested6'];
		$suggested7 = $_POST['suggested7'];		
		
        $i = '0';
        $a = array();

		if ($msg == '') {
			
        if($weakness1 !='' or $skills1 !='' or $capacity1 !='' or $suggested1 !=''){
        $d = ORM::for_table('sys_actionplan')->create();
		$d->weakness = $weakness1;
		$d->skills = $skills1;
		$d->capacity = $capacity1;
		$d->suggested = $suggested1;
		$d->itemno = '1';
		$d->resultid = $resultid;
		$d->save();
        }
		
		if($weakness2 !='' or $skills2 !='' or $capacity2 !='' or $suggested2 !=''){
		$d = ORM::for_table('sys_actionplan')->create();
		$d->weakness = $weakness2;
		$d->skills = $skills2;
		$d->capacity = $capacity2;
		$d->suggested = $suggested2;
		$d->itemno = '2';
		$d->resultid = $resultid;
		$d->save();
		}
		
		if($weakness3 !='' or $skills3 !='' or $capacity3 !='' or $suggested3 !=''){
		$d = ORM::for_table('sys_actionplan')->create();
		$d->weakness = $weakness3;
		$d->skills = $skills3;
		$d->capacity = $capacity3;
		$d->suggested = $suggested3;
		$d->itemno = '3';
		$d->resultid = $resultid;
		$d->save();
		}
		
		if($weakness4 !='' or $skills4 !='' or $capacity4 !='' or $suggested4 !=''){
		$d = ORM::for_table('sys_actionplan')->create();
		$d->weakness = $weakness4;
		$d->skills = $skills4;
		$d->capacity = $capacity4;
		$d->suggested = $suggested4;
		$d->itemno = '4';
		$d->resultid = $resultid;
		$d->save();
		}

		if($weakness5 !='' or $skills5 !='' or $capacity5 !='' or $suggested5 !=''){
		$d = ORM::for_table('sys_actionplan')->create();
		$d->weakness = $weakness5;
		$d->skills = $skills5;
		$d->capacity = $capacity5;
		$d->suggested = $suggested5;
		$d->itemno = '5';
		$d->resultid = $resultid ;
		$d->save();
		}
		
		if($weakness6 !='' or $skills6 !='' or $capacity6 !='' or $suggested6 !=''){
		$d = ORM::for_table('sys_actionplan')->create();
		$d->weakness = $weakness6;
		$d->skills = $skills6;
		$d->capacity = $capacity6;
		$d->suggested = $suggested6;
		$d->itemno = '6';
		$d->resultid = $resultid;
		$d->save();
		}
		
		if($weakness7 !='' or $skills7 !='' or $capacity7 !='' or $suggested7 !=''){
		$d = ORM::for_table('sys_actionplan')->create();
		$d->weakness = $weakness7;
		$d->skills = $skills7;
		$d->capacity = $capacity7;
		$d->suggested = $suggested7;
		$d->itemno = '1';
		$d->resultid = $resultid;
		$d->save();
		}
		
		
		$sr = ORM::for_table('sys_results')->find_one($resultid);
		$sr->actionplanid = "Yes";
		$sr->save();
		
		
			      r2(U.'client/results/');

        } else {
            echo $msg;
        }

        break;


case 'json_d_chart_data':

        header('Content-Type: application/json');

        $data = Dashboard::dataIncExpD('dd');

        echo json_encode($data);

        break;
	

case 'result_dashboard':
      
        $c = Contacts::details();
		$ui->assign('user',$c);
        $cid = $c->id;
        Event::trigger('client/result_dashboard/');

        $ui->assign('_application_menu', 'dashboard');
        $ui->assign('_st', $_L['Dashboard']);
        $ui->assign('_title', $config['CompanyName'].' - '.$_L['Dashboard']);
     
        $ui->assign('user',$c);
        $cid = $c->id;

        $d = ORM::for_table('sys_invoices')->where('userid',$c->id)->limit(5)->find_array();
        $ui->assign('d',$d);

        $first_day_month = date('Y-m-01');
        $mdate = date('Y-m-d');

        $mi = ORM::for_table('sys_transactions')->where('type','Income')->where_gte('date',$first_day_month)->where_lte('date',$mdate)->sum('cr');
        if($mi == ''){     $mi = '3';   }
        $ui->assign('mi',$mi);
        $me = ORM::for_table('sys_transactions')->where('type','Expense')->where_gte('date',$first_day_month)->where_lte('date',$mdate)->sum('dr');
        if($me == ''){   $me = '5'; }
        $ui->assign('me',$me);
        $m = ORM::for_table('sys_transactions')->where('type','Income')->where('date',$mdate)->sum('cr');
        if($m == ''){     $m = '3'; }
        $ui->assign('ti',$m);
        $m = ORM::for_table('sys_transactions')->where('type','Expense')->where('date',$mdate)->sum('dr');
        if($m == ''){   $m = '5'; }
        $ui->assign('te',$m);
        $ui->assign('jsvar',$jsvar);

      	$xheader = Asset::css(array('dashboard/dashboard'));
        $xfooter = Asset::js(array('dashboard/graph-client','chart/echarts-client.min','numeric','dashboard/dashboard-client'));
        $ui->assign('xheader', $xheader);
        $ui->assign('xfooter', $xfooter);

        $ui->display('client_result_dashboard.tpl');
		
		


break;

////////////////////////////////////////////////////////////////////////////////GRAPHS////////////////////////////////////////////////////////////

    case 'legacy':

        Event::trigger('client/legacy',array($action));
		$c = Contacts::details();
		$ui->assign('user',$c);
        $cid = $c->id;
       // $resultid = $routes['2'];
	   
        Event::trigger('client/legacy');

        $d = ORM::for_table('sys_accounts')->order_by_desc('balance')->limit(5)->find_many();
        $tbal = ORM::for_table('sys_accounts')->sum('balance');
        $tbal = number_format($tbal,'2','.','');
        $ui->assign('d',$d);
        $ui->assign('tbal',$tbal);
        $fdate = date('Y-m-01');
        $tdate = date('Y-m-t');
//first day of month
        $first_day_month = date('Y-m-01');
        $mdate = date('Y-m-d');
        $month_n = date('n');
        $mi = ORM::for_table('sys_transactions')->where('type','Income')->where_gte('date',$first_day_month)->where_lte('date',$mdate)->sum('cr');
        if($mi == ''){
            $mi = '0.00';
        }
        $ui->assign('mi',$mi);
        $me = ORM::for_table('sys_transactions')->where('type','Expense')->where_gte('date',$first_day_month)->where_lte('date',$mdate)->sum('dr');
        if($me == ''){
            $me = '0.00';
        }
        $ui->assign('me',$me);
        $m = ORM::for_table('sys_transactions')->where('type','Income')->where('date',$mdate)->sum('cr');
        if($m == ''){
            $m = '0.00';
        }
        $ui->assign('ti',$m);
        $m = ORM::for_table('sys_transactions')->where('type','Expense')->where('date',$mdate)->sum('dr');
        if($m == ''){
            $m = '0.00';
        }
        $ui->assign('te',$m);
        $out = array();

        $d = ORM::for_table('sys_transactions')->where('type','Expense')->limit(5)->order_by_desc('id')->find_many();
        $ui->assign('exp',$d);
        $d = ORM::for_table('sys_transactions')->where('type','Income')->limit(5)->order_by_desc('id')->find_many();
        $ui->assign('inc',$d);

		/////chart1
		// $d1i = ORM::for_table('sys_tests')->where('resultid',$resultid)->where('',$d1)->sum('level');
		$d1 = date('Y-m-01');
        $d1i = ORM::for_table('sys_transactions')->where('type','Income')->where('date',$d1)->sum('cr');
        if($d1i == ''){    $d1i = '3';}
        $d1e = ORM::for_table('sys_transactions')->where('type','Expense')->where('date',$d1)->sum('dr');
        if($d1e == ''){ $d1e = '5';}

        $d2 = date('Y-m-02');
        $d2i = ORM::for_table('sys_transactions')->where('type','Income')->where('date',$d2)->sum('cr');
        if($d2i == ''){ $d2i = '4';  }
        $d2e = ORM::for_table('sys_transactions')->where('type','Expense')->where('date',$d2)->sum('dr');
        if($d2e == ''){ $d2e = '5'; }

        $d3 = date('Y-m-03');
        $d3i = ORM::for_table('sys_transactions')->where('type','Income')->where('date',$d3)->sum('cr');
        if($d3i == ''){ $d3i = '3';}
		$d3e = ORM::for_table('sys_transactions')->where('type','Expense')->where('date',$d3)->sum('dr');
        if($d3e == ''){ $d3e = '5';}

        $d4 = date('Y-m-04');
        $d4i = ORM::for_table('sys_transactions')->where('type','Income')->where('date',$d4)->sum('cr');
        if($d4i == ''){   $d4i = '3'; }
		$d4e = ORM::for_table('sys_transactions')->where('type','Expense')->where('date',$d4)->sum('dr');
        if($d4e == ''){  $d4e = '5';    }

        $d5 = date('Y-m-05');
        $d5i = ORM::for_table('sys_transactions')->where('type','Income')->where('date',$d5)->sum('cr');
        if($d5i == ''){   $d5i = '4'; }
        $d5e = ORM::for_table('sys_transactions')->where('type','Expense')->where('date',$d5)->sum('dr');
        if($d5e == ''){ $d5e = '5';}

        $d6 = date('Y-m-06');
        $d6i = ORM::for_table('sys_transactions')->where('type','Income')->where('date',$d6)->sum('cr');
        if($d6i == ''){  $d6i = '3.5';  }
        $d6e = ORM::for_table('sys_transactions')->where('type','Expense')->where('date',$d6)->sum('dr');
        if($d6e == ''){ $d6e = '5';  }

        $d7 = date('Y-m-07');
        $d7i = ORM::for_table('sys_transactions')->where('type','Income')->where('date',$d7)->sum('cr');
        if($d7i == ''){ $d7i = '5.00';  }
        $d7e = ORM::for_table('sys_transactions')->where('type','Expense')->where('date',$d7)->sum('dr');
        if($d7e == ''){  $d7e = '5.00';}



        $invoices = ORM::for_table('sys_invoices')->limit(5)->order_by_desc('id')->find_many();
        $ui->assign('invoices',$invoices);
$ui->assign('_st', 'Results Dashboard');

        $ui->assign('xheader', '
<link href="'.APP_URL.'/ui/lib/c3/c3.min.css" rel="stylesheet" type="text/css">
');

        $ui->assign('xfooter', Asset::js(array('dashboard/graph-client`')).'
<script type="text/javascript" src="'.APP_URL.'/ui/lib/c3/d3.min.js"></script>
<script type="text/javascript" src="'.APP_URL.'/ui/lib/c3/c3.min.js"></script>
<script type="text/javascript" src="'.APP_URL.'/ui/lib/numeric.js"></script>
');
		$youscore = 'Your Score';
		$optimal = 'Optimal Score';
        $ui->assign('jsvar','');
        $ui->assign('xjq', '

var chart = c3.generate({
    bindto: \'#chart\',
    data: {
	columns: [

		[\''.$youscore.'\', \'0\','.$d1i.','.$d2i.', '.$d3i.', '.$d4i.', '.$d5i.', '.$d6i.', '.$d7i.'],
		[\''.$optimal.'\', \'0\','.$d1e.','.$d2e.', '.$d3e.', '.$d4e.', '.$d5e.', '.$d6e.', '.$d7e.']
	],
        type: \'area-spline\',
         colors: {
            '.$_L['Income'].': \'#000000\',
            '.$_L['Expense'].': \'#ffffff\'
        }
    }

});

var chart2 = c3.generate({
    bindto: \'#chart2\',
    data: {
	columns: [

		[\''.$youscore.'\', \'0\','.$d1i.','.$d2i.', '.$d3i.'],
		[\''.$optimal.'\', \'0\','.$d1e.','.$d2e.', '.$d3e.']
	],
        type: \'area-spline\',
         colors: {
            '.$_L['Income'].': \'#23c6c8\',
            '.$_L['Expense'].': \'#d6150d\'
        }
    }

});

var chart3 = c3.generate({
    bindto: \'#chart3\',
    data: {
	columns: [

		[\''.$youscore.'\', \'0\','.$d1i.','.$d2i.'],
		[\''.$optimal.'\', \'0\','.$d1e.','.$d2e.']
	],
        type: \'area-spline\',
         colors: {
            '.$_L['Income'].': \'#23c6c8\',
            '.$_L['Expense'].': \'#d6150d\'
        }
    }

});

var chart4 = c3.generate({
    bindto: \'#chart4\',
    data: {
	columns: [

		[\''.$youscore.'\', \'0\','.$d1i.','.$d2i.', '.$d3i.'],
		[\''.$optimal.'\', \'0\','.$d1e.','.$d2e.', '.$d3e.']
	],
        type: \'area-spline\',
         colors: {
            '.$_L['Income'].': \'#23c6c8\',
            '.$_L['Expense'].': \'#d6150d\'
        }
    }

});

var chart5 = c3.generate({
    bindto: \'#chart5\',
    data: {
	columns: [

		[\''.$youscore.'\', \'0\','.$d1i.','.$d2i.', '.$d3i.', '.$d4i.', '.$d5i.', '.$d6i.'],
		[\''.$optimal.'\', \'0\','.$d1e.','.$d2e.', '.$d3e.', '.$d4e.', '.$d5e.', '.$d6e.']
	],
        type: \'area-spline\',
         colors: {
            '.$_L['Income'].': \'#23c6c8\',
            '.$_L['Expense'].': \'#d6150d\'
        }
    }

});


  

    $(\'.amount\').autoNumeric(\'init\', {

    aSign: \''.$config['currency_code'].' \',
    dGroup: '.$config['thousand_separator_placement'].',
    aPad: '.$config['currency_decimal_digits'].',
    pSign: \''.$config['currency_symbol_position'].'\',
    aDec: \''.$config['dec_point'].'\',
    aSep: \''.$config['thousands_sep'].'\'

    });

 ');

      //  $ui->assign('content_inner',inner_contents($config['c_cache']));

        Event::trigger('client/_on_display');

        $ui->display('client_result_dashboard.tpl');



        break;

//////////////////////////////////////////////////////SHOW RESULT INFORMATION ////////////////////////////////////////////////////
case 'result-info':

        Event::trigger('client/result-info/');

        $extra_fields = '';
        $extra_jq = '';

        $c = Contacts::details();
        $ui->assign('user',$c);
		
		$ui->assign('extra_fields', $extra_fields);
        $resultid = $routes['2'];
		
        $ui->assign('_st','Result Information');
        $c = ORM::for_table('crm_accounts')->select('id')->select('account')->select('company')->select('email')->order_by_desc('id')->find_many();
        $ui->assign('c', $c);
		$tests = ORM::for_table('sys_results')->where('id',$resultid)->find_one();
		$topicid = $tests['topicid'];
		$ui->assign('resultid', $resultid);
		
		$evals = ORM::for_table('sys_evaluations')->select('id')->select('topicid')->select('account')->where('topicid',$topicid)->find_many();
        $ui->assign('evals', $evals);
			
		
		$testerid = $tests['testerid'];
		
		if($tests){
		$tester = ORM::for_table('crm_testers')->where('id',$testerid )->find_one();
		$ui->assign('tester', $tester);
		$ui->assign('tests', $tests);
		}
       
        $ui->assign('idate', date('Y-m-d'));
	
        $js_file = 'test_add';
        $tpl_file = 'result-info.tpl';
       
        $css_arr = array('s2/css/select2.min','modal','dp/dist/datepicker.min','redactor/redactor');
        $js_arr = array('redactor/redactor.min','s2/js/select2.min','s2/js/i18n/'.lan(),'dp/dist/datepicker.min','dp/i18n/'.$config['language'],'numeric');

        $ui->assign('xheader', Asset::css($css_arr));
        $ui->assign('xfooter', Asset::js($js_arr));
		
        $ui->display($tpl_file);
        
		break;
		
		
		
		
		
    default:
        echo 'action not defined';
}