<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\Analytics;

class McfDataQuery extends \Google\Site_Kit_Dependencies\Google\Collection
{
    protected $collection_key = 'sort';
    protected $internal_gapi_mappings = ["endDate" => "end-date", "maxResults" => "max-results", "startDate" => "start-date", "startIndex" => "start-index"];
    public $dimensions;
    public $endDate;
    public $filters;
    public $ids;
    public $maxResults;
    public $metrics;
    public $samplingLevel;
    public $segment;
    public $sort;
    public $startDate;
    public $startIndex;
    public function setDimensions($dimensions)
    {
        $this->dimensions = $dimensions;
    }
    public function getDimensions()
    {
        return $this->dimensions;
    }
    public function setEndDate($endDate)
    {
        $this->endDate = $endDate;
    }
    public function getEndDate()
    {
        return $this->endDate;
    }
    public function setFilters($filters)
    {
        $this->filters = $filters;
    }
    public function getFilters()
    {
        return $this->filters;
    }
    public function setIds($ids)
    {
        $this->ids = $ids;
    }
    public function getIds()
    {
        return $this->ids;
    }
    public function setMaxResults($maxResults)
    {
        $this->maxResults = $maxResults;
    }
    public function getMaxResults()
    {
        return $this->maxResults;
    }
    public function setMetrics($metrics)
    {
        $this->metrics = $metrics;
    }
    public function getMetrics()
    {
        return $this->metrics;
    }
    public function setSamplingLevel($samplingLevel)
    {
        $this->samplingLevel = $samplingLevel;
    }
    public function getSamplingLevel()
    {
        return $this->samplingLevel;
    }
    public function setSegment($segment)
    {
        $this->segment = $segment;
    }
    public function getSegment()
    {
        return $this->segment;
    }
    public function setSort($sort)
    {
        $this->sort = $sort;
    }
    public function getSort()
    {
        return $this->sort;
    }
    public function setStartDate($startDate)
    {
        $this->startDate = $startDate;
    }
    public function getStartDate()
    {
        return $this->startDate;
    }
    public function setStartIndex($startIndex)
    {
        $this->startIndex = $startIndex;
    }
    public function getStartIndex()
    {
        return $this->startIndex;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\Analytics\McfDataQuery::class, 'Google\\Site_Kit_Dependencies\\Google_Service_Analytics_McfDataQuery');
