<?php
/**
 * @package   solo
 * @copyright Copyright (c)2014-2021 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Solo\Controller;


class Fsfilters extends ControllerDefault
{
	public function __construct($config = array())
	{
		parent::__construct($config);

		// Register the two additional tasks
		$this->registerTask('normal', 'main');
		$this->registerTask('tabular', 'main');
	}

	/**
	 * Default task
	 *
	 * @return  void
	 */
	public function main()
	{
		$task = $this->input->getCmd('task', 'normal');

		if ($task == 'main')
		{
			$task = 'normal';
		}

		$this->getModel()->setState('browse_task', $task);

		$this->display();
	}

	/**
	 * AJAX proxy method
	 *
	 * @return  void
	 */
	public function ajax()
	{
		// Parse the JSON data and reset the action query param to the resulting array
		$action_json = $this->input->get('akaction', '', 'raw');
		$action = json_decode($action_json);

		/** @var \Solo\Model\Fsfilters $model */
		$model = $this->getModel();
		$model->setState('action', $action);

		$ret = $model->doAjax();

		@ob_end_clean();
		echo '#"\#\"#' . json_encode($ret) . '#"\#\"#';
		flush();

		$this->container->application->close();
	}
} 
